s        L>   = >  
      
                               hp605x      HP605X                                            ViRsrc   	 	ViSession     ViStatus   	 	ViBoolean      	 
ViBoolean[]     ViInt32     	  ViInt32[]    ViReal64     
  	ViReal64[]       ViChar[]       HP Electronic Load Family
     r    These functions are high-level functions useful for simplifying some of the instrument's more complex features.
     J    Theses functions are related to the instrument's measurement subsystem.
     D    These functions are useful only for multiple channel instruments.
     B    These functions deal with the instrument's protection features.
     D    These functions configure the instrument's input characteristics.
     C    These functions relate to the instrument's transient sub-system.
         These functions relate to the instrument's trigger subsystem.  Triggers are used to change the instrument's output based on certain operating conditions and to generate more complex outputs.
     1    These functions are various utility functions.
     l    These commands permit the user to bypass the driver and use the instrument's native programming language.
     :    This function initializes a session with an instrument.
     2    The resource ID used to identify the instrument.     L    If true, the driver will verify the instrument is supported by the driver.     F    If true, the driver will reset the instrument during initialization.     :    The instrument handle returned by the instrument driver.        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
    " 6 >         Resource Name                     \ 6         Id Query                           6v        Reset Device                                Instrument Handle                 @y       Status                               % Do Query VI_TRUE Skip Query VI_FALSE  * Reset Device VI_TRUE Don't Reset VI_FALSE    	           	           j    This function sets the instrument's mode of operation, corresponding input level, and enables the input.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
         This parameter selects the operating mode of the electronic load.

Parameter         Description
-------------------------------------
MODE_CURRENT      Constant current
MODE_RESISTANCE   Constant resistance
MODE_VOLTAGE      Constant voltage
     \    This parameter sets the instrument's corresponding immediate level for its specified mode.    
  b         Instrument Handle                 
E i       Status                             @        Mode                              
 Ii        Level                                  	                      uConstant Current HP605X_MODE_CURRENT Constant Resistance HP605X_MODE_RESISTANCE Constant Voltage HP605X_MODE_VOLTAGE            This function configures the instrument for continuous transient mode operation.  Continuous transients are oscillating currents, resistances, or voltages with a programmable frequency and duty cycle.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     X    The percentage of the total cycle for which the output remains at the transient level.     $    The frequency of the oscillations.         This parameter selects the operating mode of the electronic load.

Parameter         Description
-------------------------------------
MODE_CURRENT      Constant current
MODE_RESISTANCE   Constant resistance
MODE_VOLTAGE      Constant voltage
     \    This parameter sets the instrument's corresponding immediate level for its specified mode.     \    This parameter sets the instrument's corresponding transient level for its specified mode.    	 9         Instrument Handle                         Status                             1 9        Duty Cycle                        1 1         Frequency                         ] (       Mode                              Z  9        Immediate Level                             Transient Level                        	                              uConstant Current HP605X_MODE_CURRENT Constant Resistance HP605X_MODE_RESISTANCE Constant Voltage HP605X_MODE_VOLTAGE                This function configures an arbitrary set of channels in a mainframe load for parallel operation.  Each channel is configured identically and all channels will respond synchronously to any specified transients or triggers.
     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
    i    This parameter sets the current programming slew rate.  The programmed slew rate is used for all programmed current changes except when the input is enabled or disabled.  The hardware implements discrete slew rates and automatically selects the one that is closest to the programmed value.  To determine the actual rate, read it directly from the instrument.          This parameter specifies the value of the programmed current level on occurrence of a trigger. The change to the input level occurs at the specified slew rate.           This parameter enables or disables the Transient Subsystem.  When the subsystem is disabled, the transient current, transient mode, transient pulse width, and transient current parameters are not used.      *    This parameter selects the type of operation provided by the transient generator.

TRAN_MODE_PULSE
Pulse mode provides a triggered one-shot pulse with the specified pulse duration.  When a trigger occurs, the input goes to the specified transient level for the specified transient pulse width and then returns to its non-transient level.

TRAN_MODE_TOGGLE
Toggle mode causes the input to switch between the non-transient level and the transient level on alternate triggers.  Odd triggers set transient level; even triggers set the non-transient level.
         Transient pulse width specifies the duration of the transient level during the pulse mode.  This parameter is ignored when the transient mode is set to toggle.         The parameter specifies the value of the programmed current level for the transient input.  The electronic load input current will switch between the main level and the transient level at a rate determined by the specified current slew.        This parameter selects the electronic load trigger source.

TRIG_SOUR_BUS
Accepts a bus trigger as the trigger source.  This mode guarantees that all previous commands will be completed before the trigger is executed.

TRIG_SOUR_EXTERNAL
Selects the electronic load's external Trigger jack as the trigger source.  The user must ensure that the trigger occurs at a valid time with respect to commands that are already being processed or are pending.

TRIG_SOUR_HOLD
Only the immediate trigger causes a trigger in this mode.  All others, including the bus trigger, are ignored.

TRIG_SOUR_LINE
This generates triggers in synchronization with the AC line frequency.  This parameter may only be used for multiple-channel electronic loads.

TRIG_SOUR_TIMER
Selects the multiple electronic load's internal trigger osillator as the trigger source.  The oscillator begins running as soon as this command is executed.  The oscillator period is set in the timer parameter.  The timer trigger source can be used with pulse mode to generate synchronous, continuous transient waveforms on multiple channels.  This parameter may only be used for multiple-channel electronic loads.
         This parameter determines the period of the trigger pulses generated by the multiple electronic load's internal trigger oscillator.  This parameter is ignored when the trigger source is not set to the timer.     *    The number of channels to be configured.     4    An array specifying the channels to be configured.    " .         Instrument Handle                 g       Status                            ; 0.        Current Slew                                Trigger Current                   W |8        Transient State                   , w       Transient Mode                    ^  . 	       Transient Pulse Width                
       Transient Current                         Trigger Source                    $  .        Trigger Timer                     %o 0 .        Number of Channels                % 0         Channels                               	                 "  Enabled VI_TRUE Disabled VI_FALSE               <Pulse HP605X_TRAN_MODE_PULSE Toggle HP605X_TRAN_MODE_TOGGLE                       Bus HP605X_TRIG_SOUR_BUS External HP605X_TRIG_SOUR_EXTERNAL Hold HP605X_TRIG_SOUR_HOLD Line HP605X_TRIG_SOUR_LINE Timer HP605X_TRIG_SOUR_TIMER                d    This function configures the instrument to change its input characteristics when a trigger occurs.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
    B    This parameter selects the electronic load trigger source.

TRIG_SOUR_BUS
Accepts a bus trigger as the trigger source.  This mode guarantees that all previous commands will be completed before the trigger is executed.

TRIG_SOUR_EXTERNAL
Selects the electronic load's external Trigger jack as the trigger source.  The user must ensure that the trigger occurs at a valid time with respect to commands that are already being processed or are pending.

TRIG_SOUR_HOLD
Only the immediate trigger causes a trigger in this mode.  All others, including the bus trigger, are ignored.
         This parameter selects the operating mode of the electronic load.

Parameter         Description
-------------------------------------
MODE_CURRENT      Constant current
MODE_RESISTANCE   Constant resistance
MODE_VOLTAGE      Constant voltage
     \    This parameter sets the instrument's corresponding immediate level for its specified mode.     Z    This parameter sets the instrument's corresponding trigger level for its specified mode.    ) 0         Instrument Handle                 *D        Status                            , ) f       Trigger Source                    .b )U       Mode                              /_ 2        Immediate Level                   /  0        Trigger Level                          	                      WBus HP605X_TRIG_SOUR_BUS External HP605X_TRIG_SOUR_EXTERNAL Hold HP605X_TRIG_SOUR_HOLD               uConstant Current HP605X_MODE_CURRENT Constant Resistance HP605X_MODE_RESISTANCE Constant Voltage HP605X_MODE_VOLTAGE                This function configures the electronic load for triggered transient operation.  A triggered transient is a transient waveform that uses the trigger subsystem to specify its behavior.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
        This parameter sets the transient mode of operation.

TRAN_MODE_PULSE
Pulse mode provides a triggered one-shot pulse with a programmable pulse duration.  When a trigger occurs, the input goes to the specified transient level, for the duration of the specified pulse width and then returns to its non-transient level.  This mode is not retriggerable; triggers that occur while the input is at the transient level are ignored.  In multiple electronic loads, the trigger is applied to all channels simultaneously and the timer trigger source can be used to produce synchronized load waveforms.  The frequency parameter is ignored when this parameter is specified.

TRAN_MODE_TOGGLE
Toggle mode causes the input to switch between its non-transient level and its transient level on alternate triggers.  Odd triggers set the transient level; even triggers set the non-transient level.  The duty cycle and frequency parameters are ignored when this parameter is specified.
     |    For pulse mode, the parameter specifies the duration of the transient level.

For toggle mode, this parameter is ignored.
         This parameter selects the operating mode of the electronic load.

Parameter         Description
-------------------------------------
MODE_CURRENT      Constant current
MODE_RESISTANCE   Constant resistance
MODE_VOLTAGE      Constant voltage
     \    This parameter sets the instrument's corresponding immediate level for its specified mode.     \    This parameter sets the instrument's corresponding transient level for its specified mode.    B    This parameter selects the electronic load trigger source.

TRIG_SOUR_BUS
Accepts a bus trigger as the trigger source.  This mode guarantees that all previous commands will be completed before the trigger is executed.

TRIG_SOUR_EXTERNAL
Selects the electronic load's external Trigger jack as the trigger source.  The user must ensure that the trigger occurs at a valid time with respect to commands that are already being processed or are pending.

TRIG_SOUR_HOLD
Only the immediate trigger causes a trigger in this mode.  All others, including the bus trigger, are ignored.
    3& *         Instrument Handle                 3k       Status                            5? !#       Transient Mode                    9 *        Pulse Width                       9         Mode                              :          Immediate Level                   :         Transient Level                   ;X ! `       Trigger Source                         	                      <Pulse HP605X_TRAN_MODE_PULSE Toggle HP605X_TRAN_MODE_TOGGLE                   uConstant Current HP605X_MODE_CURRENT Constant Resistance HP605X_MODE_RESISTANCE Constant Voltage HP605X_MODE_VOLTAGE                       WBus HP605X_TRIG_SOUR_BUS External HP605X_TRIG_SOUR_EXTERNAL Hold HP605X_TRIG_SOUR_HOLD    O    This function configures the driver's method for detecting instrument errors.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
    Z    This parameter selects the type of error detection to use.

INST_ERROR_DETECT_OFF
The driver makes no attempt to detect instrument errors.

INST_ERROR_DETECT_POLL
The driver attempts to detect instrument errors by polling the instrument after each function call.  This method is slower than "INST_ERROR_DETECT_INTERRUPT" but does not configure the instrument's status registers.

INST_ERROR_DETECT_INTERRUPT
The driver attempts to detect instrument errors by monitoring the instrument's service request.  This method uses the instrument's status registers to configure the service request mechanism.
        This parameter instructs the driver to wait a fixed number of milliseconds after each command in order to detect an instrument error.  The driver typically operates much faster than the instrument.  Consequently, it is possible for the driver to begin execution of another command before the instrument has completed its previous instruction.  When "errorDetection" is set to "INST_ERROR_DETECT_INTERRUPT" the instrument may not have time to generate a service request before the driver begins the next command.  In this case, the driver will report the instrument error once the following command has completed.  By providing a longer wait time, instrument errors are more likely to be detected at the time the incorrect command is completed.

NOTE:
This parameter is only necessary to avoid the confusion caused by an instrument error being reported too late.  It is still an effective method for periodically determining the error state of the instrument.  For optimum performance, this parameter can be set to zero.
    @ K         Instrument Handle                 A7 i       Status                            C 8        Error Detection                   Em Ai        Wait Time                              	                      qOff HP605X_INST_ERROR_DETECT_OFF Poll HP605X_INST_ERROR_DETECT_POLL Interrupt HP605X_INST_ERROR_DETECT_INTERRUPT            This function gets the maximum amount of time each measurement function will wait for a response from the instrument before returning with a status of VI_ERROR_TMO.
     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     9    The number of milliseconds before the driver times out.    K =         Instrument Handle                 K        Status                            M C         Milliseconds                           	           	            [    This function returns the current, voltage, or power at the input of the electronic load.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
         This parameter specifies which type of measurement to make.

Parameter      Description
----------------------------
MEAS_CURRENT   Input current
MEAS_POWER     Input power
MEAS_VOLTAGE   Input voltage
     /    The measurement returned from the instrument.    O G         Instrument Handle                 OG       Status                            Q = w       Measurement Type                  Q <        Measurement                            	                      PCurrent HP605X_MEAS_CURRENT Power HP605X_MEAS_POWER Voltage HP605X_MEAS_VOLTAGE    	               This function sets the maximum amount of time each measurement function will wait for a response from the instrument before returning with a status of VI_ERROR_TMO.
     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     9    The number of milliseconds before the driver times out.    T$ *         Instrument Handle                 Ti       Status                            V= H         Milliseconds                           	                   This parameter selects the type of channel to read.

Parameter   Description
--------------------------------------
CHAN        Presently selected channel
CHAN_MAX    Maximum allowable channel
CHAN_MIN    Minimum allowable channel
     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     o    The type of limit to return.

CURR_MAX
    The maximum peak current.

CURR_MIN
    The minimum peak current.
     -    The channel value read from the instrument.    X"  K         Instrument Handle                 Xg        Status                            Z; 3        Channel Type                      Z 2        Channel                                	                      LPresent Setting HP605X_CHAN Maximum HP605X_CHAN_MAX Minimum HP605X_CHAN_MIN    	                This function selects the multiple electronic load channel to which all subsequent channel-specific commands will be directed.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     A    The load channel used for subsequent channel-specific commands.    \ 4         Instrument Handle                 \        Status                            ^ J         Channel                                	                  This function clears the latch that disables the output when an overvoltage (OV), overcurrent (OC), overtemperature (OT), remote inhibit (RI), or power rail fault condition is detected.  All conditions that generated the fault must be removed before the latch can be cleared.  The output is then restored to the state it was in before the fault condition occurred.

See Also:
setCurrentProtection, setRiDfi, setVoltageProtection
     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
    a ]         Instrument Handle                 a b       Status                                 	              This function sets a limit to the input current that the electronic load will sink.  A current limit may be specified for the single electronic load or for a channel of the multiple electronic load.  When the input current reaches the current limit for the specified delay period, the input of the electronic load or channel is shut off and draws no current.  This, in effect, provides a "soft circuit breaker" for the input current.  The clear input protection function re-enables the input current.  The trigger-activated current functions automatically keep track of incoming triggers while the input is shut down and will respond to the trigger as soon as the protection fault is cleared.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     K    This parameter enables or disables the over-current protection mechanism.         This parameter specifies the time that the input current may equal or exceed the current limit before the over-current protection mechanism is engaged.      *    The value used to set the current limit.    f >         Instrument Handle                 g        Status                            h ? H        State                             iC C         Delay                             i C        Current Limit                          	         "  Enabled VI_TRUE Disabled VI_FALSE            }    This function reads any one of the instrument's current configuration settings or any one its current configuration limits.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
    
    This parameter selects the type of configuration setting or limit to read.

Parameter       Description
----------------------------------------------------
CURR            Presently selected immediate current
CURR_MAX        Maximum allowable immediate current
CURR_MIN        Minimum allowable immediate current
CURR_SLEW       Presently selected current slew rate
CURR_SLEW_MAX   Maximum allowable current slew rate
CURR_SLEW_MIN   Minimum allowable current slew rate
CURR_TLEV       Presently selected transient current
CURR_TLEV_MAX   Maximum allowable transient current
CURR_TLEV_MIN   Minimum allowable transient current
CURR_TRIG       Presently selected trigger current
CURR_TRIG_MAX   Maximum allowable trigger current
CURR_TRIG_MIN   Minimum allowable trigger current
     G    The current configuration setting or limit read from the instrument.     k h         Instrument Handle                 l'd       Status                            m         Current Type                      q bd        Current                                	                     Present Current HP605X_CURR Maximum Current HP605X_CURR_MAX Minimum Current HP605X_CURR_MIN Present Current Slew Rate HP605X_CURR_SLEW Maximum Current Slew Rate HP605X_CURR_SLEW_MAX Minimum Current Slew Rate HP605X_CURR_SLEW_MIN Present Transient Current HP605X_CURR_TLEV Maximum Transient Current HP605X_CURR_TLEV_MAX Minimum Transient Current HP605X_CURR_TLEV_MIN Present Trigger Current HP605X_CURR_TRIG Maximum Trigger Current HP605X_CURR_TRIG_MAX Minimum Trigger Current HP605X_CURR_TRIG_MIN    	           y    This function reads the instrument's presently selected current range, maximum current range, or minimum current range.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
        This parameter selects the type of current range to read.

Parmater        Description
------------------------------------------------
CURR_RANG       Presently selected current range
CURR_RANG_MAX   Maximum allowable current range
CURR_RANG_MIN   Minimum allowable current range
     -    The current range read from the instrument.    t n         Instrument Handle                 u i       Status                            v O        Current Range Type                x Ni        Current Range                          	                      }Present Current Range HP605X_CURR_RANG Maximum Current Range HP605X_CURR_RANG_MAX Minimum Current Range HP605X_CURR_RANG_MIN    	           8    This function reads one of the instrument's registers.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
        This parameter selects the register to read.

Parameter             Description
----------------------------------------------------------
REG_ESE               Event status enable register
REG_ESR               Event status register
REG_SRE               Service request enable register
REG_STB               Status byte
REG_STAT_OPER         Operation event register
REG_STAT_OPER_COND    Operation condition register
REG_STAT_OPER_ENAB    Operation enable register
REG_STAT_OPER_NTR     Operation negative transition filter
REG_STAT_OPER_PTR     Operation positive transition filter
REG_STAT_QUES         Questionable event register
REG_STAT_QUES_COND    Questionable condition register
REG_STAT_QUES_ENAB    Questionable enabled register
REG_STAT_CHAN         Channel event register
REG_STAT_CHAN_COND    Channel condition register
REG_STAT_CHAN_ENAB    Channel enable register
REG_STAT_CSUM         Channel summary event register
REG_STAT_CSUM_ENAB    Channel summary enable register
     5    The value of the register read from the instrument.    yi i         Instrument Handle                 zB_       Status                            |         Register Type                              Register Value                         	                     Event status enable HP605X_REG_ESE Event status HP605X_REG_ESR Service request enable HP605X_REG_SRE Status byte HP605X_REG_STB Operation event HP605X_REG_STAT_OPER Operation event condition HP605X_REG_STAT_OPER_COND Operation event enable HP605X_REG_STAT_OPER_ENAB Operation event NTR HP605X_REG_STAT_OPER_NTR Operation event PTR HP605X_REG_STAT_OPER_PTR Questionable event HP605X_REG_STAT_QUES Questionable event condition HP605X_REG_STAT_QUES_COND Questionable event enable HP605X_REG_STAT_QUES_ENAB Channel event HP605X_REG_STAT_CHAN Channel event condition HP605X_REG_STAT_CHAN_COND Channel event enable HP605X_REG_STAT_CHAN_ENAB Channel summary event HP605X_REG_STAT_CSUM Channel summary event enable HP605X_REG_STAT_CSUM_ENAB    	               This function reads any one of the instrument's resistance configuration settings or any one its resistance configuration limits.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
    p    This parameter selects the type of resistance to read.

Parameter      Description
------------------------------------------------------
RES            Presently selected immediate resistance
RES_MAX        Maximum allowable immediate resistance
RES_MIN        Minimum allowable immediate resistance
RES_TLEV       Presently selected transient resistance
RES_TLEV_MAX   Maximum allowable transient resistance
RES_TLEV_MIN   Minimum allowable transient resistance
RES_TRIG       Presently selected trigger resistance
RES_TRIG_MAX   Maximum allowable trigger resistance
RES_TRIG_MIN   Minimum allowable trigger resistance 
     J    The resistance configuration setting or limit read from the instrument.      h         Instrument Handle                  f       Status                             '        Resistance Type                   2 Vf        Resistance                             	                   	  zPresent Resistance HP605X_RES Maximum Resistance HP605X_RES_MAX Minimum Resistance HP605X_RES_MIN Present Transient Resistance HP605X_RES_TLEV Maximum Transient Resistance HP605X_RES_TLEV_MAX Minimum Transient Resistance HP605X_RES_TLEV_MIN Present Trigger Resistance HP605X_RES_TRIG Maximum Trigger Resistance HP605X_RES_TRIG_MAX Minimum Trigger Resistance HP605X_RES_TRIG_MIN    	               This function reads the instrument's presently selected resistance range, maximum resistance range, or minimum resistance range.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
    %    This parameter selects the type of resistance range to read.

Parameter      Description
--------------------------------------------------
RES_RANG       Presently selected resistance range
RES_RANG_MAX   Maximum allowable resistance range
RES_RANG_MIN   Minimum allowable resistance range
     0    The resistance range read from the instrument.     s         Instrument Handle                  j       Status                             N        Resistance Range Type              Mj        Resistance Range                       	                      Present Resistance Range HP605X_RES_RANG Maximum Resistance Range HP605X_RES_RANG_MAX Minimum Resistance Range HP605X_RES_RANG_MIN    	               This function gets the maximum amount of time each non-measurement function will wait for a response from the instrument before returning with a status of VI_ERROR_TMO.
     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     9    The number of milliseconds before the driver times out.    :  $         Instrument Handle                  {       Status                            S `         Milliseconds                           	           	            }    This function reads any one of the instrument's voltage configuration settings or any one its voltage configuration limits.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
        This parameter selects the type of voltage to read.

Parameter       Description
----------------------------------------------------
VOLT            Presently selected immediate voltage
VOLT_MAX        Maximum allowable immediate voltage
VOLT_MIN        Minimum allowable immediate voltage
VOLT_TLEV       Presently selected transient voltage
VOLT_TLEV_MAX   Maximum allowable transient voltage
VOLT_TLEV_MIN   Minimum allowable transient voltage
VOLT_TRIG       Presently selected trigger voltage
VOLT_TRIG_MAX   Maximum allowable trigger voltage
VOLT_TRIG_MIN   Minimum allowable trigger voltage
VOLT_SLEW       Presently selected voltage slew rate
VOLT_SLEW_MAX   Maximum allowable voltage slew rate
VOLT_SLEW_MIN   Minimum allowable voltage slew rate
     G    The voltage configuration setting or limit read from the instrument.       o         Instrument Handle                  g       Status                             %        Voltage Type                       Tg        Voltage                                	                     Present Voltage HP605X_VOLT Maximum Voltage HP605X_VOLT_MAX Minimum Voltage HP605X_VOLT_MIN Present Voltage Slew Rate HP605X_VOLT_SLEW Maximum Voltage Slew Rate HP605X_VOLT_SLEW_MAX Minimum Voltage Slew Rate HP605X_VOLT_SLEW_MIN Present Transient Voltage HP605X_VOLT_TLEV Maximum Transient Voltage HP605X_VOLT_TLEV_MAX Minimum Transient Voltage HP605X_VOLT_TLEV_MIN Present Trigger Voltage HP605X_VOLT_TRIG Maximum Trigger Voltage HP605X_VOLT_TRIG_MAX Minimum Trigger Voltage HP605X_VOLT_TRIG_MIN    	           =    This function configures the instrument's current settings.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
        This parameter selects the type of current setting to configure.

Parameter       Description
----------------------------------------------------------------
CURR            Set the immediate current to the specified value
CURR_MAX        Set the immediate current to its maximum value
CURR_MIN        Set the immediate current to its minimum value
CURR_TRIG       Set the trigger current to the specified value
CURR_TRIG_MAX   Set the trigger current to its maximum value
CURR_TRIG_MIN   Set the trigger current to its minimum value
CURR_SLEW       Set the current slew rate to the specified value
CURR_SLEW_MAX   Set the current slew rate to its maximum value
CURR_SLEW_MIN   Set the current slew rate to its minimum value
CURR_TLEV       Set the transient current to the specified value
CURR_TLEV_MAX   Set the transient current to its maximum value
CURR_TLEV_MIN   Set the transient current to its minimum value
     0    The value used to specify the current setting.    o	 m         Instrument Handle                  g       Status                             &        Current Type                      ' wg        Current                                	                     Specified Current HP605X_CURR Maximum Current HP605X_CURR_MAX Minimum Current HP605X_CURR_MIN Specified Current Slew Rate HP605X_CURR_SLEW Maximum Current Slew Rate HP605X_CURR_SLEW_MAX Minimum Current Slew Rate HP605X_CURR_SLEW_MIN Specified Transient Current HP605X_CURR_TLEV Maximum Transient Current HP605X_CURR_TLEV_MAX Minimum Transient Current HP605X_CURR_TLEV_MIN Specified Trigger Current HP605X_CURR_TRIG Maximum Trigger Current HP605X_CURR_TRIG_MAX Minimum Trigger Current HP605X_CURR_TRIG_MIN       O    This function selects the full-scale current range of the electronic load.  Programming any value within the low range automatically selects the low range and programming any value within the high range automatically selects that range.

NOTE:
Whenever the electronic load changes range, it momentarily hoes into the disabled state.
     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
         This parameter specifies how to set the current range.

Parameter       Description
---------------------------------------
CURR_RANG       Use the specified value
CURR_RANG_MAX   Use the maximum value
CURR_RANG_MIN   Use the minimum value
     B    The value used to set the instrument's full-scale current range.    	 b         Instrument Handle                  c       Status                             R        Current Range Type                 [c        Current Range                          	                      Specified Current Range HP605X_CURR_RANG Maximum Current Range HP605X_CURR_RANG_MAX Minimum Current Range HP605X_CURR_RANG_MIN           This function applies the equivalent of an electronic short across the input of the electronic load.  The actual condition of the electronic load under a short condition depends on its operating mode as follows:

Mode of Operation      Shorted Condition
----------------------------------------
High-Range CC Mode     Max current
Low-Range CC Mode      Max current
Low-Range CR Mode      Min resistance
Middle-Range CR Mode   Min resistance
High-Range CR Mode     Min resistance
CV Mode                Min voltage

If a mode or current or resistance range is changed, the short will be reapplied new mode or range.  If a trigger is received while a short is enabled, any triggered levels are stored and will be transferred to the main level after the short is disabled.  Triggers received during a short are also applied to the transient subsystem.  This ensures that after the short is programmed off, the transients on the shorted channel will still be synchronized with those of channels that had remained unshorted.
     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     =    This parameter is used to enable or disable an input short.     H         Instrument Handle                         Status                             @         Input Short                            	         " Enabled VI_TRUE Disabled VI_FALSE   Q    This function turns the electronic load input on and off.  When the input is off, the electronic load will draw minimal current at its input.  Turning the input off overrides an input short.  The presently programmed slew rate setting is not used when turning the input on or off; the current and voltage change at their maximum rates.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     E    This parameter is used to disable or enable the instrument's input.    
 F         Instrument Handle                 O        Status                            # @         State                                  	         " Enabled VI_TRUE Disabled VI_FALSE    B    This function selects the operating mode of the electronic load.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
         This parameter selects the operating mode of the electronic load.

Parameter         Description
-------------------------------------
MODE_CURRENT      Constant current
MODE_RESISTANCE   Constant resistance
MODE_VOLTAGE      Constant voltage
     U         Instrument Handle                  i       Status                             dL       Mode                                   	                      uConstant Current HP605X_MODE_CURRENT Constant Resistance HP605X_MODE_RESISTANCE Constant Voltage HP605X_MODE_VOLTAGE       This command controls the general-purpose digital port on the rear of each electronic load or each channel of the multiple electronic load.  The state of the port is with respect to the common side of the electronic load input.  Setting a port to the off state connects it to the common; setting a port to the on state disconnects it from command and sets it to a TTL logical high.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     \    The value used to set the general-purpose digital port on the read of the electronic load.    ^ F         Instrument Handle                         Status                            w @         Port                                   	         " Enabled VI_TRUE Disabled VI_FALSE    9    This function writes one of the instrument's registers.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
        REG_ESE
This parameter sets the condition of the standard event status enable register, which determines which events of the standard event status event register are allowed to set the event summary bit of the status byte register.

REG_SRE
This parameter sets the condition of the service request enable register, which determines which events of the status byte register are allowed to set the master status summary bit. 

REG_STAT_OPER_ENAB
A mask that specifies which bits of the operation status event register are allowed to be summed into the operation bit of the status byte register.

REG_STAT_OPER_NTR
A filter that specifies whether or not a 1-to-0 transition in the condition register will set the corresponding bit in the event register. 

REG_STAT_OPER_PTR
A filter that specifies whether or not a 0-to-1 transition in the condition register will set the corresponding but in the event register.

REG_STAT_QUES_ENAB
A mask that specifies which bits of the questionable event register can be summed into the questionable bit of the status byte register.

REG_STAT_CHAN_ENAB
A mask that specifies which bits of the channel status event register will be allowed to be summed into the appropriate channel bit of the channel summary register.

REG_STAT_CSUM_ENAB
A mask that specifies which bits of the channel summary event register can be selected to set the status byte register channel summary bit.
     6    The value of the register written to the instrument.     Q         Instrument Handle                 5       Status                            	 .        Register Type                     ʗ _        Register Value                         	                     nEvent status enable HP605X_REG_ESE Service request enable HP605X_REG_SRE Operation event enable HP605X_REG_STAT_OPER_ENAB Operation event NTR HP605X_REG_STAT_OPER_NTR Operation event PTR HP605X_REG_STAT_OPER_PTR Questionable event enable HP605X_REG_STAT_QUES_ENAB Channel event enable HP605X_REG_STAT_CHAN_ENAB Channel summary event enable HP605X_REG_STAT_CSUM_ENAB        @    This function configures the instrument's resistance settings.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
        This parameter selects the type of resistance setting to configure.

Parameter    Description
----------------------------------------------------------------
RES          Set the immediate resistance to the specified value
RES_MAX      Set the immediate resistance to its maximum value
RES_MIN      Set the immediate resistance to its minimum value
RES_TRIG     Set the trigger resistance to its specified value
RES_TRIG_MAX Set the trigger resistance to its maximum value
RES_TRIG_MIN Set the trigger resistance to its minimum value
RES_TLEV     Set the transient resistance to the specified value
RES_TLEV_MAX Set the transient resistance to its maximum value
RES_TLEV_MIN Set the transient resistance to its minimum value
     3    The value used to specify the resistance setting.    ͂  l         Instrument Handle                  l       Status                            ϛ )        Resistance Type                   { bl        Resistance                             	                   	  Specified Resistance HP605X_RES Maximum Resistance HP605X_RES_MAX Minimum Resistance HP605X_RES_MIN Specified Transient Resistance HP605X_RES_TLEV Maximum Transient Resistance HP605X_RES_TLEV_MAX Minimum Transient Resistance HP605X_RES_TLEV_MIN Specified Trigger Resistance HP605X_RES_TRIG Maximum Trigger Resistance HP605X_RES_TRIG_MAX Minimum Trigger Resistance HP605X_RES_TRIG_MIN           The function selects the full-scale resistance range of the electronic load.  Programming any value equal to or greater than zero and less than or equal to the maximum value of the lowest range automatically selects that range.  Programming any value greater than the minimum range and less than or equal to the maximum value of the middle range automatically selects that range.  There is no overlap between the low and middle ranges.  Programming a value greater than the maximum value of the middle range automatically selects the highest value.

NOTE:
Whenever the electronic load changes resistance range, the input momentarily goes into the off state.
     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
         This parameter specifies how to set the resistance range.

Parameter      Description
--------------------------------------
RES_RANG       Use the specified value
RES_RANG_MAX   Use the maximum value
RES_RANG_MIN   Use the minimum value
     -    The value used to set the resistance range.     t         Instrument Handle                  x       Status                             O        Resistance Range Type              Xx        Resistance Range                       	                      Specified Resistance Range HP605X_RES_RANG Maximum Resistance Range HP605X_RES_RANG_MAX Minimum Resistance Range HP605X_RES_RANG_MIN            This function sets the maximum amount of time each non-measurement function will wait for a response from the instrument before returning with a status of VI_ERROR_TMO.
     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     9    The number of milliseconds before the driver times out.    > E         Instrument Handle                 ݃       Status                            W c         Milliseconds                           	               =    This function configures the instrument's voltage settings.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
        This parameter selects the type of voltage setting to configure.

Parameter       Description
----------------------------------------------------------------
VOLT            Set the immediate voltage to the specified value
VOLT_MAX        Set the immediate voltage to its maximum value
VOLT_MIN        Set the immediate voltage to its minimum value
VOLT_TRIG       Set the trigger voltage to the specified value
VOLT_TRIG_MAX   Set the trigger voltage to its maximum value
VOLT_TRIG_MIN   Set the trigger voltage to its minimum value
VOLT_TLEV       Set the transient voltage to the specified value
VOLT_TLEV_MAX   Set the transient voltage to its maximum value
VOLT_TLEV_MIN   Set the transient voltage to its minimum value
     0    The value used to specify the voltage setting.     \         Instrument Handle                 f       Status                             '        Voltage Type                       `f        Voltage                                	                     Specified Voltage HP605X_VOLT Maximum Voltage HP605X_VOLT_MAX Minimum Voltage HP605X_VOLT_MIN Specified Voltage Slew Rate HP605X_VOLT_SLEW Maximum Voltage Slew Rate HP605X_VOLT_SLEW_MAX Minimum Voltage Slew Rate HP605X_COLT_SLEW_MIN Specified Transient Voltage HP605X_VOLT_TLEV Maximum Transient Voltage HP605X_VOLT_TLEV_MAX Minimum Transient Voltage HP605X_VOLT_TLEV_MIN Specified Trigger Voltage HP605X_VOLT_TRIG Maximum Trigger Voltage HP605X_VOLT_TRIG_MAX Minimum Trigger Voltage HP605X_VOLT_TRIG_MIN        @    This function configures the instrument's transient subsystem.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
         This parameter enables or disables the Transient Subsystem.  When the subsystem is disabled, the transient mode, duty cycle/width, and frequency parameters are not used.           For continuous mode, this parameter specifies the duty cycle of the transient level, as a percent of the total cycle.

For pulse mode, the parameter specifies the duration of the transient level.

For toggle mode, this parameter is ignored.
     |    For continuous mode, this parameter specifies the pulse frequency.

For pulse and toggle mode, this parameter is ignored.
        This parameter sets the transient mode of operation.

TRAN_MODE_CONTINUOUS
Continuous mode provides periodic pulses of the specified frequency and duty cycle.  Each channel has its own oscillator that runs asynchronously with respect to oscillators of other channels.

TRAN_MODE_PULSE
Pulse mode provides a triggered one-shot pulse with a programmable pulse duration.  When a trigger occurs, the input goes to the specified transient level, for the duration of the specified pulse width and then returns to its non-transient level.  This mode is not retriggerable; triggers that occur while the input is at the transient level are ignored.  In multiple electronic loads, the trigger is applied to all channels simultaneously and the timer trigger source can be used to produce synchronized load waveforms.  The frequency parameter is ignored when this parameter is specified.

TRAN_MODE_TOGGLE
Toggle mode causes the input to switch between its non-transient level and its transient level on alternate triggers.  Odd triggers set the transient level; even triggers set the non-transient level.  The duty cycle and frequency parameters are ignored when this parameter is specified.
     %         Instrument Handle                 >        Status                             3 /        Transient State                    7        Duty Cycle Or Pulse Width           %        Frequency                         F .
       Transient Mode                         	         " Enabled VI_TRUE Disabled VI_FALSE                       cContinuous HP605X_TRAN_MODE_CONTINUOUS Pulse HP605X_TRAN_MODE_PULSE Toggle HP605X_TRAN_MODE_TOGGLE        The function applies only to trigger functions.  It cancels all pending trigger levels in all operating modes and on all channels.  As a result, subsequent triggers have no effect on the input level.  The transient system remains unaffected.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     L         Instrument Handle                 w       Status                                 	           ?    This function configures the instrument's trigger sub-system.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
        This parameter selects the electronic load trigger source.

TRIG_SOUR_BUS
Accepts a bus trigger as the trigger source.  This mode guarantees that all previous commands will be completed before the trigger is executed.

TRIG_SOUR_EXTERNAL
Selects the electronic load's external Trigger jack as the trigger source.  The user must ensure that the trigger occurs at a valid time with respect to commands that are already being processed or are pending.

TRIG_SOUR_HOLD
Only the immediate trigger causes a trigger in this mode.  All others, including the bus trigger, are ignored.

TRIG_SOUR_LINE
This generates triggers in synchronization with the AC line frequency.

TRIG_SOUR_TIMER
Selects the multiple electronic load's internal trigger osillator as the trigger source.  The oscillator begins running as soon as this command is executed.  The oscillator period is set in the timer parameter.  The timer trigger source can be used with pulse mode to generate synchronous, continuous transient waveforms on multiple channels.
         This parameter determines the period of the trigger pulses generated by the multiple electronic load's internal trigger oscillator.  This parameter is ignored when the trigger source is not set to the timer.     ]         Instrument Handle                  _       Status                             3        Trigger Source                     L_        Timer                                  	                      Bus HP605X_TRIG_SOUR_BUS External HP605X_TRIG_SOUR_EXTERNAL Hold HP605X_TRIG_SOUR_HOLD Line HP605X_TRIG_SOUR_LINE Timer HP605X_TRIG_SOUR_TIMER        6    This function generates a trigger event immediately.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
         This parameter selects the type of trigger.

TRIG_BUS
This command generates a trigger to any subsystem that has BUS selected as its source. 

TRIG_IMMEDIATE
This parameter generates a trigger signal regardless of the selected trigger source. 
    n  L         Instrument Handle                  p       Status                            H"       Trigger Type                           	                      4Bus HP605X_TRIG_BUS Immediate HP605X_TRIG_IMMEDIATE    (    This function performs a device clear.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
    W         Instrument Handle                 f       Status                                 	           ]    This function suspends program execution for at least the specified number of milliseconds.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     2    The number of milliseconds to suspend execution.    Q         Instrument Handle                j       Status                           	 Z         Milliseconds                           	               \    This function provides a text description for errors returned by any driver function call.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     2    The status returned by a previous function call.     %    The text description of the status.   	 h         Instrument Handle                N]       Status                           
" > h        Status Code                      
\ 4]        Message                                	               	               This function returns the next error number followed by its corresponding error message string from the instrument's remote programming error queue.  The queue is a FIFO (first-in, first-out) buffer that stores errors as they occur.  As it is read, each error is removed from the queue.  When all errors have been read, the query returns "0, No Error". If more errors are accumulated than the queue can hold, the last error in the queue is "-350, Too Many Errors".     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     *    A number representing the type of error.          A string describing the error.   W  c         Instrument Handle                 B       Status                           p / b        Error Code                        5B        Error Message                          	           	            	               This command restores the electronic load to a state that was previously stored in memory with the save function.

Recall also does the following:
* Forces an abort before resetting any parameters.
* Clears the input protection after all parameters have been recalled.
* Sets the channel to 1 for the multiple electronic load.

State 0 is the only state stored in non-volatile memory and is restored at power-on.  Locations 1-6 are stored in volatile memory.  If one of the volatile locations is recalled without having already been saved, the instrument will default to state 0.

NOTE:
Recall does not affect any status enable registers or transition filters.
     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     =    The memory location used to restore the instrument's state.   e D         Instrument Handle                 s       Status                           ~ G         Location                               	               C    This function resets the instrument to its factory-defined state.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     F         Instrument Handle                        Status                                 	           X    This function returns the driver's version and the instrument's identification string.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
         The driver's version.     )    The instrument's identification string.    \         Instrument Handle                 L       Status                            4 \        Instrument Driver Revision        4L        Firmware Revision                      	           	            	               This function stores the present state of the single electronic load and the states of all channels of the multiple electronic load in a specified memory location.  Locations 0 through 6 may be used.  Location 0 is in nonvolatile memory and retains its state throughout power cycling.  The electronic load will be set to the state in location 0 at power turn-on.  If no state has been saved to location 0, then it will still contain the factory-default state.  States stored in locations 1 through 6 are lost whenever the power is cycled.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     :    The memory location used to save the instrument's state.   "=  E         Instrument Handle                " t       Status                           $V _         Location                               	               p    This function initiates an instrument self-test and checks for any instrument errors resulting from this test.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     0    A code indicating the result of the self-test.     >    A string describing the error detected during the self-test.   %  ]         Instrument Handle                & (       Status                           ' 6 W        Self Test Result                 ( 7'        Self Test Message                      	           	            	               This function waits until all pending instrument operations are completed.  Pending operations are complete when:
* All commands sent before "wait" have been executed.
* All triggered actions are completed and the trigger system returns to the Idle state.
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
     =    The instrument's VISA session handle returned from "init".
   *` a       Status                           ,4 G         Instrument Handle                  	               ?    This command sends a SCPI command directly to the instrument.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
         The SCPI command to be sent.   -:  X         Instrument Handle                - S       Status                           /S c         Command                                	               e    This command sends a SCPI command directly to the instrument and accepts a 32-bit integer argument.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
         The SCPI command to be sent.     ?    A 32-bit integer argument to be appended to the SCPI command.   0 Q         Instrument Handle                0 f       Status                           2 F U        Command                          2 Ck        Argument                               	                   g    This command sends a SCPI command directly to the instrument and waits for a 32-bit integer response.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
         The SCPI command to be sent.     4    A 32-bit integer value returned by the instrument.   4z  Z         Instrument Handle                4 G       Status                           6 J [        Command                          6 =D        Response                               	               	            _    This command sends a SCPI command directly to the instrument and waits for a string response.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
         The SCPI command to be sent.     &    A string returned by the instrument.   8P  7         Instrument Handle                8        Status                           :i A 7        Command                          : 3        Response                         ?         Size                                   	               	                -    This function closes an instrument session.     =    The instrument's VISA session handle returned from "init".
        The meaning of the status returned by the function is as follows:

 = 0  "VI_SUCCESS"    The function completed successfully.
 > 0  Warning         The function completed, but an
                      exceptional condition occurred which
                      may require attention.
 < 0  Error           The function did not complete
                      successfully.

Use the "error_message" function to get a textual description of errors and warnings.
   < I         Instrument Handle                <dz       Status                                 	                        K.    init                                     	  
z     K.    configureInput                             "     K.    configureContinuousTransient             9  %     K.    configureParallelLoads                   )  0%     K.    configureTrigger                         2e  =     K.    configureTriggeredTransient              @  Is     K.    setInstrumentErrorDetection              J  M     K.    getMeasTimeout                           N  R&     K.    measure                                  Su  V~     K.    setMeasTimeout                           W1  Z     K.    getChannel                               \2  _     K.    setChannel                               _  c     K.    clearInputProtection                     d  j     K.    setCurrentProtection                     k]  q_     K.    getCurrent                               tO  xA     K.    getCurrentRange                          y  :     *    getRegister                                     K.    getResistance                                   K.    getResistanceRange                              K.    getTimeout                               O  :     K.    getVoltage                               *  _     K.    setCurrent                               O       K.    setCurrentRange                          y       K.    setInputShort                              p     K.    setInputState                            D       K.    setMode                                         K.    setPort                                  ¯       K.    setRegister                              :  Ҷ     K.    setResistance                            -       K.    setResistanceRange                       ܋  ߘ     K.    setTimeout                               K       K.    setVoltage                                      K.    setTransient                                    K.    abort                                    h       K.    setTrigger                               0      K.    trigger                                 w      K.    dcl                                     : 	     K.    doDelay                                 
 
     K.    error_message                           }      K.    error_query                                   K.    recall                                  v      K.    reset                                   T      K.    revision_query                            $     K.    save                                    %K (Z     K.    self_test                               )V ,y     K.    wait                                    , /y     K.    cmd                                     0, 3     K.    cmdInt                                  4 6     K.    cmdInt_Q                                7 :     K.    cmdString_Q                             ; >8     K.    close                                 M                                     DInitialize                          qApplication Functions                DConfigure Input                      DConfigure Continuous Transient       DConfigure Parallel Loads             DConfigure Trigger                    DConfigure Triggered Transient        DSet Instrument Error Detection      Measure                              DGet Measurement Timeout              DMeasure                              DSet Measurement Timeout             =Multiple Channels                    DGet Channel                          DSet Channel                         Protection                           DClear Input Protection               DSet Current Protection              Source                               DGet Current                          DGet Current Range                    DGet Register                         DGet Resistance                       DGet Resistance Range                 DGet Timeout                          DGet Voltage                          DSet Current                          DSet Current Range                    DSet Input Short                      DSet Input State                      DSet Mode                             DSet Port                             DSet Register                         DSet Resistance                       DSet Resistance Range                 DSet Timeout                          DSet Voltage                         Transient                            DSet Transient                       jTrigger                              DAbort                                DSet Trigger                          DTrigger                             3Utility                              DDevice Clear                         DDo Delay                             DError Message                        DError Query                          DRecall                               DReset                                DRevision Query                       DSave                                 DSelf Test                            DWait                                lPassthrough                          DCommand                              DCommand Integer                      DCommand Integer Query                DCommand String Query                 DClose                           